// acad.js - JavaScript functions for ACAD Help Files
// 
// v.0.33: 24aug07 - Added highlighting in CHM/HTML files (Asheem Mamoowala)
// v.0.32: 29aug03 - updatd var release value to 19
// v.0.31: 14jul03 - added CreateSecwinObject
// v.0.30: 27may03 - added the ShowCHM to launch a CHM (use jumpHTM to open an HTML file)
// v.0.29: 16aug02 - added getcurpath2 function
// v.0.28: 14aug02 - added popGloss function
// v.0.27: 17may02 - fixed ShowAll so CSS styles with a leading "noshow" are ignored
//                   and IMG tags are ignored.
// v.0.26: 16apr02 - updated getcurpath function, it wasn't returning the proper path 
//		     when an "ms-its" protocol was used.
// v.0.25: 27mar02 - moved string constants to the ac.strings.js file
// v.0.24: 13mar02 - fixed ShowAll so it doesn't show "noshow" class items 
// v.0.23: 28feb02 - added: getcurfilename, getcurchmname, and getcurpath functions
// 		     used by AC.CHM-UPDATE.JS
// v.0.22: 05feb02 - strip hash and all that follows in doComments function
// v.0.21: 31jan02 - remove question marks from title in doComments function
// v.0.20: 07dec01 - added IE/Netscape browser check
// v.0.19: 18oct01 - added strnextpage and strlastpage
//		   - fixed showAll so it can handle a file with a #
// v.0.18: 25jul01 - fixed DoComments so it works with "webhelp" also
// v.0.17: 24jan01 - added CheckForUpdates function
// v.0.16: 12jan01 - added unescape to jumpHTM function
// v.0.15: 05jan01 - updated showinfo, added strings
// v.0.14: 14dec00 - added showinfo
// v.0.13: 13nov00 - added nextpage and prevpage functions (not working yet)
// v.0.12: 24may00 - added chmpath to doComments function
// v.0.11: 04may00 - fixed "display/collapse" all hidden text message so 
//		     it changes when clicked
// v.0.10: 03may00 - adjusted the height of the Comments dialog
// v.0.09: 26apr00 - added control of 'click4more' image in toggleLeadin
//		     added control of 'click4more' image in toggleProc
//		     deleted csJump function
//		     added localizable constants
// v.0.08: 06apr00 - updated autoExpand so it really works!
// v.0.07: 27mar00 - added doComments function
// v.0.06: 22mar00 - added build_hhrun_object
// v.0.05: 01mar00 - added extra "/" to jumpHTM
// v.0.04: 29feb00 - updated jumpCHM
// v.0.03: 09dec99 - added autoExpand
// v.0.02: 08dec99 - added jumpHTM and jumpCHM
// v.0.01: 30nov99 - the beginning
//
//===========================================================================
// Constants:  *** Now pulled from ac.strings.js ***

//var strclick4more   = "Click for more...";
//var strclick2hide   = "Click to hide...";
//var strcollapsetext = "Collapse all hidden text on this page.";
//var strprevpage     = "Previous page.";
//var strnextpage     = "Next page.";
//var strlastpage     = "Last page.";
//var strfirstpage    = "First page.";
//var strtopicupdate  = "The following information superceeds that found in this topic:";
//var hh_classid      = "clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11";
//var hh_codebase     = "hhctrl.ocx#Version=4,74,8793,0";

//===========================================================================

// the build, lang, and prod variables are defined in ac_common.js
//var build  = "U070";
//var lang   = "ENU";
//var prod   = "ACAD";
var release = "19";
var achelpscript = "http://www.autodesk.com/cgi-bin/achelp15.pl";
var script = achelpscript + "?type=UPDATES";

var isIE = 0;
if(navigator.appName == "Microsoft Internet Explorer") { isIE = 1; }

function CheckForUpdates () {
  var updateurl = script+"&build="+build+"&lang="+lang+"&prod="+prod+"&rel="+release;
  location.href = updateurl;
}

function doComments(path) {
  var stitle = document.title;
  stitle = stitle.replace( /[\?]/g, "_" );  // remove question marks from title (others?)
  var surl   = unescape(location.href);
  surl = surl.replace( /#.*$/, "" );  // strip hash and all that follows
  var i = surl.indexOf("::");
  if( i == -1 ) {
    i = surl.lastIndexOf("/"); 
    chmpath = surl.substring(0,i+1);
  } else {
    chmpath = surl.substring(0,i+3);
  }
  window.open(chmpath+path+"#"+stitle+" ["+surl+"]",null,"height=450,width=450,resizable=yes,directories=no,location=no,menubar=no,status=no,toolbar=no" );
}

  function hideInfo() {
                info = document.getElementById('infoline');
                info.innerHTML = ' ';
                info.style.visibility = 'hidden';
            }
            function showInfo(title) {
                info = document.getElementById('infoline');
                info.innerHTML = title;
                info.style.visibility='visible';
            }

// Jump to local non-compiled HTML file from a CHM
// jumpHTM('drivers.htm');
function jumpHTM(file) {
  var path = unescape(location.pathname);
  var i = path.lastIndexOf("\\");
  var j = path.indexOf(":", 3);
  path = path.substring(j+1,i+1);
  location.href = "file:///" + path + file;
}

// Jump to a local CHM file from a non-compiled HTML file
// jumpCHM('acad_acr.chm::/acr_l30.html');
function jumpCHM(file_topic) {
  var path = location.pathname;
  var i = path.lastIndexOf("\\");
  path = path.substring(1,i+1);
  location.href = "ms-its:" + path + file_topic;
}

// Builds a ShortCut object to launch a CHM (with local path)
// build_hhrun_object - 
//
function build_hhrun_object(file) {
  //var path = location.pathname;
  var path = unescape(location.pathname);
  var i = path.lastIndexOf("\\");
  var j = path.indexOf(":", 3);
  path = path.substring(j+1,i+1);
  document.writeln("<OBJECT id=hhrun type='application/x-oleobject'");
  document.writeln("  classid='"+hh_classid+"'");
  document.writeln("  codebase='"+hh_codebase+"'>");
  document.writeln(" <PARAM name='Command' value='ShortCut'>");
  document.writeln(" <PARAM name='Item1' value=',hh.exe," + path + file + "'>");
  document.writeln(" <PARAM name='Window'  value='bogus.html'>");
  document.writeln("</OBJECT>");
}

function getpath() {
  var path = location.pathname;
  var i = path.lastIndexOf("\\");
  var j = path.indexOf(":", 3);
  path = path.substring(j+1,i+1);
  return path;
}

function MakeArray(n) {
  this.length = n;
  for (var i = 1; i <= n; i++) { 
    this[i] = 0;
  }
  return this;
}

function toggleLeadin() {
  if( leadin.style.display == "" ) {
    leadin.style.display = "none";
    click4more.src = "ac.chickletred.gif";
    click4more.title = strclick4more;
  }
  else {
    leadin.style.display="";
    click4more.src = "ac.chickletred2.gif";
    click4more.title = strclick2hide;
  }
}

var lastspan = new MakeArray(5);
var lastlink = new MakeArray(5);
function togglespan( level, spanname, linkname ) {
  if( spanname.style.display == "" ) {
    spanname.style.display = "none";
    lastspan[level] = 0;
    lastlink[level] = 0;
    if( linkname != null ) {
      linkname.style.fontWeight = "";
    }
  }
  else {
    spanname.style.display="";
    if( lastspan[level] != 0 ) { 
      lastspan[level].style.display = "none"; 
      lastlink[level].style.fontWeight = "";
    }
    lastspan[level] = spanname;
    if( linkname != null ) {
      lastlink[level] = linkname;
      linkname.style.fontWeight = "bold";
    }
  }
}

var allon = 0;
//var showall1 = 0;
function showAll() {
  if( allon == 1 ) {
    var loc = document.location.href;
    var i1 = loc.indexOf("#");
    if( i1 != -1 ) { loc = loc.substring(0,i1); }
    document.location.href = loc;
  }
  else {
    for ( i=0; i < document.all.length; i++ ) {
      var itm = document.all.item(i);
      if( itm.className.substring(0,6) != "noshow" ) {  // CSS styles with a leading "noshow" are ignored
      //if( document.all.item(i).className != "noshow" ) {
        if( itm.tagName != "IMG" ) {
          document.all.item(i).style.display = "";
        }
      }
    }
    allon = 1;
    //if( showall1 != 0 ) {
      document.all.showall1.innerText = strcollapsetext;
    //  showall2.innerText = "";
    //}
  }
}

function autoExpand( exp ) {
  if( exp == 1 ) { showAll(); }
}

function toggleproc( procname, imgname, anchor ){
  if( isIE == 1 ) {
    var i = document.location.href.lastIndexOf("#");
    var cur_href = "";
    eval("var linkid = "+procname.id+"link");
    if( i > 0 ) { cur_href = document.location.href.substring(0,i); }
    if( procname.style.display == "" ) {
      procname.style.display = "none";
      imgname.src = "ac.right.gif";
      linkid.title = strclick4more;
    }
    else {
      procname.style.display="";
      imgname.src = "ac.down.gif";
      linkid.title = strclick2hide;
    }
  }
}

function getcurfilename () {
  var surl = unescape(location.href);
  var i = surl.indexOf("::");
  if( i == -1 ) { // NOT A CHM
    i = surl.lastIndexOf("/"); 
    filename = surl.substring(i+1,surl.length);
  } else {
    filename = surl.substring(i+3,surl.length);
  }
  var j = filename.indexOf("#");
  if( j != -1 ) { filename = filename.substring(0,j); }
  j = filename.indexOf("?");
  if( j != -1 ) { filename = filename.substring(0,j); }
  return filename;
}

function getcurchmname () {
  var surl = unescape(location.href);
  var chmname = "";
  var i = surl.indexOf("::");
  if( i != -1 ) {
    chmname = surl.substring(0,i);
    var j = chmname.lastIndexOf("\\"); 
    if( j != -1 ) { chmname = chmname.substring(j+1,chmname.length); }
  }
  return chmname;
}

function getcurpath () {
  var path = unescape(location.pathname);
  var i = path.lastIndexOf("\\");
  var j = 0;
  if( path.indexOf("::") != -1 ) { // it's a CHM
    if( path.charAt(0) == "@" ) { // this is a @MSITStore: .. chop this off
      j = path.indexOf(":") + 1;
    }
    else { // this is an ms-its: .. path starts at the beginning of string
      // do nothing
    }
  }
  else { j++; }
  path = path.substring(j,i+1);
  return path;
}

function getcurpath2 () {
  var path = unescape(location.pathname);
  if( path.indexOf("@MSITStore:") == 0 ) {
    path = path.substring(11,path.length);
  }
  if( path.indexOf("/") == 0 ) {
    path = path.substring(1,path.length);
  }
  var i = path.lastIndexOf("\\");
  var j = 0;
  path = path.substring(j,i+1);
  return path;
}

var ispop = 0;
var popid = null;
function popGloss(gloss_text) {
  var gloss_file = gloss_text.replace(/ +/g, "_");
  var top  = event.screenY + 10;
  var left = event.screenX - 150;
  //alert("X:"+left+" Y:"+top);
  if( ispop == 1 ) { popid.close(); }
  popid = window.showModelessDialog("gloss_"+gloss_file+".html","Dialog Arguments Value","dialogHeight: 250px; dialogWidth: 300px; dialogTop: "+top+"; dialogLeft: "+left+"; edge: Raised; center: Yes; help: No; resizable: Yes; status: No; unadorned: yes; ");
  ispop = 1;
}

// ShowCHM - Launches a CHM in a new window, path is relative to the current CHM's folder
// 	ShowCHM('acad_nfw.chm::/1acad.html');
//
function ShowCHM (file) {
  var filepath = "mk:@MSITStore:" + getcurpath() + file;
  window.showHelp(filepath);
}

// CreateSecwinObject - creates a secondary window object
//
function CreateSecwinObject(id, winname, file) {
  var surl = unescape(location.href);
  var chmname = "";
  var i = surl.indexOf("::");
  if( i != -1 ) {
    chmname = surl.substring(0,i);
    var j = chmname.lastIndexOf("\\");
    if( j != -1 ) { chmname = chmname.substring(j+1,chmname.length); }
  }

  document.writeln("<OBJECT id="+id+" type=\"application/x-oleobject\" classid=\"clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11\" codebase=\"hhctrl.ocx#Version=4,74,8793,0\">");
  document.writeln("    <PARAM name=\"Command\" value=\"Related Topics\">");
  document.writeln("    <PARAM name=\"Window\" value=\""+winname+"\">");
  // Note that "Help" in the following line is supposed to be the window title, but it 
  // is really overridden by the title defined in the HHP (I think)
  document.writeln("    <PARAM name=\"Item1\" value=\"Help;"+chmname+"::/"+file+"\">");
  document.writeln("</OBJECT>");

}


// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFFYYAdg8X+Uz
// SIG // q+PILLAsJqVvX8fhoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFAf14uFawtnMI6N5GzZLsTtk5FywMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAa
// SIG // 0gDc2RDBS3d7Aowv4Kk4fpnEFLOnlMVhLwFxEcBcP3lA
// SIG // bi3pPG1JaNBekNYycg5PyBL3Ez8KKN47TM8CUnulSJsL
// SIG // 7PQ5CNeQijNfgXhM8HPJpARxzx0V//Xi8sVycDcVRtpJ
// SIG // oZaID26564Kg7Il8YgVu9XSeEEJEHhij2aygxqGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjI1NDU2
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUhc172jQ9XhONhT2BAat5
// SIG // TelDzCAwDQYJKoZIhvcNAQEBBQAEgYDEkZqqs+e5/gVQ
// SIG // Dk6ImKoVnDh7iKD4fIdKdkyOguBZcFtha1kKamCn4vOu
// SIG // BEcyPtdDzrkwUU2DULB1kSH/FBspA75Tep0V8DrTE3zG
// SIG // emcM9K8dWTI1eT2pOsyG5uqDdS3tmbFai504XrVL0oZP
// SIG // ssEBJCWZPMav2w/X+UOLQKK/6A==
// SIG // End signature block
